title Create argc and argv. coded by wbinvd

        include segments.inc

;------ Start of extrns ---------------------------------------
        extrnp  GetCommandLine

        extrn   new:near,resize:near,delete:near
;------ End of extrns -----------------------------------------

;I have forgot this, but is the last string in C/C++ (argv) NULL???
LASTARGVISNULL  equ     1

        public  argc,argv
        public  InitializeCommandLine,DeinitializeCommandLine

        startbss
argc            dd      ?               ;# of arguments, including the filename
argv            dd      ?               ;Ptr to array with arguments
        endbss

        startcode
;Initialize the command line
;In:    None
;Out:   CF=1    Some kind of error occured
;       CF=0    Everything's AOK
;Regs:  None
InitializeCommandLine   proc near
        pushad
        call    GetCommandLine
        xor     esi,esi
        xchg    esi,eax                 ;ESI=Command line string
        cdq                             ;EDX=# of argv strings in argv array
        mov     argc,eax
        mov     argv,eax
        xchg    ebx,eax                 ;EBX=[argv]

@@StringLoop:
        call    RemoveSpaces
        cmp     CharType ptr [esi],00h  ;No more arguments?
        je      short @@EndOfStringLoop
        call    FindEndOfArg
        mov     ebp,eax                 ;Save end of argument (start of next)
        mov     ecx,eax                 ;end of argument
        sub     ecx,esi                 ;end - start
        cmp     ecx,2*CharSize          ;Can it be two '"' characters?
        jb      short @@No
        cmp     CharType ptr [esi],'"'  ;Is the 1st character '"'?
        jne     short @@No
        cmp     CharType ptr [eax-1*CharSize],'"' ;Is the last char '"'?
        jne     short @@No
        inc     esi
        dec     eax
ifdef UNICODE
        inc     esi
        dec     eax
endif
@@No:
        sub     eax,esi
        jbe     short @@Zero
        mov     ecx,eax                 ;Save string length in ECX
ifdef UNICODE
        inc     eax
endif
        inc     eax                     ;Include the ending zero
        call    new
        jc      short @@Error
        xchg    edi,eax                 ;EDI=Allocated string
        call    ResizeArgvArray
        jc      short @@ErrorDeleteEDI
        mov     [ebx+edx*4-04h],edi     ;Save string
        rep movsb                       ;Copy the string to our allocated string
        mov     CharType ptr [edi],00h  ;Terminate the string
@@Zero:
        mov     esi,ebp                 ;Next argument
        jmp     short @@StringLoop

@@EndOfStringLoop:
ifdef LASTARGVISNULL
        call    ResizeArgvArray         ;Allocate a new entry (NULL)
        jc      short @@Error
        dec     argc                    ;ResizeArgvArray incremented it
endif
@@666:
        popad
        retn
@@ErrorDeleteEDI:
        xchg    edi,eax                 ;String we allocated
        call    delete
@@Error:
        call    DeinitializeCommandLine
        stc
        jc      short @@666
InitializeCommandLine   endp

;Resize the argv array with one more dword and set it to 00000000h
;In:    EDX     # of dwords allocated in argv
;       EBX     [argv]
;Out:   CF=1    Out of memory
;         All registers are preserved
;       CF=0    Not out of memory
;         EBX   new address of argv
;         EDX   incremented by one
;         [argc] incremented by one
;         [argv] updated with the value in EBX
;Regs:  EDX,EBX
ResizeArgvArray         proc near
        push    eax ecx
        mov     eax,ebx                 ;Resize EBX
        lea     ecx,[edx*4+00000004h]   ;Allocate one more dword
        call    resize
        jc      short @@666
        mov     argv,eax
        inc     argc
        xchg    ebx,eax
        and     dword ptr [ebx+edx*4],00000000h
        inc     edx
@@666:
        pop     ecx eax
        retn
ResizeArgvArray         endp

;Remove the spaces and tab characters
;In:    ESI     String
;Out:   ESI     After the spaces and tabs
;Regs:  EAX,ESI
RemoveSpaces            proc near
@@Loop:
        lodsb_
        cmp     al_,' '
        je      short @@Loop
        cmp     al_,09h
        je      short @@Loop
ifdef UNICODE
        dec     esi
endif
        dec     esi
        retn
RemoveSpaces            endp

;Find the character after the last character in the current argument
;In:    ESI     Start of argument string
;Out:   CF=1    No more arguments
;       CF=0
;         EAX   After the last character in the arg
;Regs:  EAX,ESI
FindEndOfArg            proc near
        push    esi
        lodsb_                          ;Get character
        cmp     al_,'"'
        jne     short @@Loop2StartHere

;Loop until we find the ending '"' or a 00h
@@Loop1:
        lodsb_
        cmp     al_,'"'                 ;The last '"' character?
        jne     short @@No
        lodsb_                          ;Get the character after '"'
        cmp     al_,' '
        je      short @@666             ;If we find '" ', exit
@@No:
        test    al_,al_
        jnz     short @@Loop1
        jz      short @@666

;Loop until we find a ' ' or 00h
@@Loop2:
        lodsb_
@@Loop2StartHere:
        cmp     al_,' '
        je      short @@666
        test    al_,al_
        jnz     short @@Loop2

@@666:
        xchg    esi,eax
ifdef UNICODE
        dec     eax
endif
        dec     eax
        pop     esi
        retn
FindEndOfArg            endp

;Free the memory we allocated earlier. You might want to call this procedure
;after you've checked the command line to save some memory :)
;In:    None
;Out:   None
;Regs:  None
DeinitializeCommandLine proc near
        push    eax ecx edx
        mov     ecx,argc
        mov     edx,argv
        test    edx,edx
        jz      short @@666
        jecxz   @@FreeArgvStringsLoopEnd
@@FreeArgvStringsLoop:
        mov     eax,[edx]
        add     edx,00000004h
        call    delete
        loop    @@FreeArgvStringsLoop
@@FreeArgvStringsLoopEnd:
        mov     eax,argv
        call    delete
@@666:
        xor     eax,eax
        mov     argv,eax
        mov     argc,eax
        pop     edx ecx eax
        retn
DeinitializeCommandLine endp
        endcode
        end
